* bark_beetle_random.sas;
title "One-way ANOVA for bark beetle sampling study";
data bark_beetle;
	input site $ count;
	* Apply transformations here;
	y = log10(count);
	datalines; 
1   137
1   101
1   113
1    48
1   155
2   156
2   165
2   652
2   179
2   757
3   278
3   197
3    95
3   395
3    83
4  2540
4   613
4   200
4   251
4   390
5    18
5    16
5    11
5    21
5    14
;
run;
* Print data set;
proc print data=bark_beetle;
run;
* Plot means, standard errors, and observations;
proc gplot data=bark_beetle;
	plot y*site=1 / vaxis=axis1 haxis=axis1;
	symbol1 i=std1mjt v=star height=2 width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
* One-way ANOVA with random effects - F test;
proc mixed method=type3 cl data=bark_beetle;
	class site;
	model y = / ddfm=kr;
	random site;
run;
* One-way ANOVA with random effects - variance components;
proc mixed cl plots=residualpanel data=bark_beetle;
	class site;
	model y = / ddfm=kr;
	random site;
run;
quit;
